/*
 RFID-RC522 conectat
  SS pin  →    GIOP5
  SCK pin →    GIOP18
  MOSI pin  →  GIOP23
  MISO pin  →  GIOP19
  IRQ pin(not connected)  
  GND pin → GND
  RST pin → GIOP 16//merge cuprtoboard
  VCC pin → 3.3V
iteste codul tagului
trimite pe telefon

compara cu codul prestabilit
si comanda ON OFF ledul placa GPIO 2
 Oled conectat: SDA la GPIO21 SCK la GPIO22
 link inspiratie
 https://esp32io.com/tutorials/esp32-rfid-nfc 
  se conecteaza la router local
  IP 192.168.0.102
  dupa incarcare, pe Oled si Serial Monitor 
  apare adresa IP IP 192.168.0.102
  Se dexchide pe Android Chrome
  Se introdice IP 192.168.0.102/webserial
  apare pagina web
  tot ce se editeaza  pe telefon apare pe Oled
 Se poate conecta inca un telefon cu acelasi IP
 
*/
#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <WebSerial.h>

AsyncWebServer server(80);
const char* ssid = "UPCF4821BC";          // Your WiFi SSID
const char* password = "Gherla1956";  // Your WiFi Password
 
#include <SPI.h>
#include <MFRC522.h>

#define SS_PIN  5  // ESP32 pin GIOP5 
//#define RST_PIN 4
#define RST_PIN 16
MFRC522 mfrc522(SS_PIN, RST_PIN);   
#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

void recvMsg(uint8_t *data, size_t len){
  WebSerial.println("Received Data...");
  String d = "";
  for(int i=0; i < len; i++){
    d += char(data[i]);
    Serial.println(d);
    display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("Primit=");
  display.print(d);//afiseaza text tranmmsis pe oled
  display.display();
  }
  WebSerial.println(d);
}
void setup() {
  SPI.begin(); // init SPI bus
  mfrc522.PCD_Init();   // Initiate MFRC522
  Serial.println("Tap an RFID/NFC tag on the RFID-RC522 reader");
   
    Serial.begin(115200);
    WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) {
    Serial.printf("WiFi Failed!\n");
    return;
  }
  Serial.print("IP Address: ");
  Serial.println(WiFi.localIP());
  
    // WebSerial is accessible at "<IP Address>/webserial" in browser
    WebSerial.begin(&server);
    /* Attach Message Callback */
    WebSerial.msgCallback(recvMsg);
    server.begin();
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("webserial IP=");
  display.print(WiFi.localIP());
  display.print("/webserial");
  
  display.display();
  delay(5000);
  pinMode(2,OUTPUT);
}
    

void loop() {

if ( ! mfrc522.PICC_IsNewCardPresent()) 
  {
    return;
  }
  // Select one of the cards
  if ( ! mfrc522.PICC_ReadCardSerial()) 
  {
    return;
  }
  //Show UID on serial monitor
  Serial.print("UID tag :");
  String content= "";
  byte letter;
  for (byte i = 0; i < mfrc522.uid.size; i++) 
  {
      content.concat(String(mfrc522.uid.uidByte[i] < 0x10 ? " 0" : " "));
      content.concat(String(mfrc522.uid.uidByte[i], DEC));
 
  Serial.print(content);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("UID=");
  display.print(content); 
  display.display();
  }
  Serial.println();
  Serial.print("Message : ");
  content.toUpperCase();
  if (content.substring(1) == "210 230 29 43") 
  //trebuie codul zecimal, adica 210 230 29 43 pentru card 
  //codul HEX card D232 E6100 1D50 2B50
  //2132 0A51 9451 8532 cod HEX tag

  {
    Serial.println("Authorized access");
    Serial.println();
    digitalWrite(2, HIGH); 
    display.print(" access OK"); //afiseaza bine daca las DEC
    WebSerial.println(" Access OK");
    display.display();
    delay(3000);
    display.clearDisplay();
  }
 
 else   {
    Serial.println(" Access denied");
    digitalWrite(2, LOW); 
     display.print(" Access denied"); //afiseaza bine daca las DEC
     WebSerial.println(" Access denied");
    display.display();
    delay(3000);
    display.clearDisplay();
 }
    WebSerial.println(" UID=");
    WebSerial.println(content);
      }
      
